<?php

require_once "../../../../../asset/mod/autoLoad.php";
require_once "../../../layout/conn.php";
require_once "../../../layout/session.php";

$crud = new crudData;
$link = new linkpage;

$format = new format;
$sim_transaksi = new simakom_transaksi;

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;

//$show = $db->runQuery("SELECT * FROM  $tb_transaksi order by tanggal desc,jenis asc,  bukti asc, time asc");
$query = "SELECT  * FROM  $tb_transaksi WHERE uraian LIKE :search || tanggal LIKE :search || bukti LIKE :search order by tanggal desc,jenis asc, bukti asc, time asc LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();

//$datas = $stmt->fetchAll(PDO::FETCH_ASSOC);
$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$total = $pdo->prepare("SELECT COUNT(*) FROM $tb_transaksi WHERE uraian LIKE :search || tanggal LIKE :search || bukti LIKE :search");
$total->bindValue(':search', "%$search%", PDO::PARAM_STR);
$total->execute();
$totalRows = $total->fetchColumn();
$totalPages = ceil($totalRows / $limit);

$rows = '';
foreach ($datas as $data) {


    $tanggal = $format->dateToIndo($data->tanggal);
    $debet = $format->ribuan($data->debet);
    $kredit = $format->ribuan($data->kredit);
    $detail_id = $data->rkas_detail_id;
    $jenis_transaksi = $data->jenis;


    if ($jenis_transaksi == 13 || $jenis_transaksi == 14 || $jenis_transaksi == 33 || $jenis_transaksi == 34) {
        $akun = $data->pajak_akun;
    } else {
        $akun = $data->rkas_kategori . '.' . $data->rkas_kegiatan . '.' . $data->rkas_komponen . '.' . $data->rkas_akun;
    };

    $cekRefRKAS = $sim_transaksi->getRefRKAS($tb_detail, $detail_id);
    if ($cekRefRKAS > 0 || $jenis_transaksi == 21 ||  $jenis_transaksi == 22 || $jenis_transaksi == 13 || $jenis_transaksi == 14 || $jenis_transaksi == 33 || $jenis_transaksi == 34 || $jenis_transaksi > 40) {
        $warningNoRef = "#FFFFFF";
    } else {
        $warningNoRef = "#E9967A";
    };




    if ($jenis_transaksi == 31 || $jenis_transaksi == 32 || $jenis_transaksi == 35 || $jenis_transaksi == 36 || $jenis_transaksi == 43 || $jenis_transaksi == 44 || $jenis_transaksi == 45 || $jenis_transaksi == 46) {
        $printKuitansi = "<a " . $link->pageID($data->id, 'transaksi/kuitansi_printpreview') . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-printer'></i> CETAK</a>";
    } else {
        $printKuitansi = "";
    };



    $rows .= "<tr bgcolor=$warningNoRef>";
    $rows .= "<td width='5px'><input type='checkbox' class='d-inline small chk_boxes1' name='selectRow' value='" . $data->id . "'></td>";
    $rows .= "<td> <a " . $link->pageID($data->id, 'transaksi/transaksi_edit') . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-pencil-square'></i> EDIT</a>";
    $rows .= "<td>" . $data->bukti . "</td>";
    $rows .= "<td>" . $format->dateToIndo($data->tanggal) . "</td>";
    $rows .= "<td>" . $format->entityEncode($data->uraian) . "</td>";
    $rows .= "<td>" . $debet . "</td>";
    $rows .= "<td>" . $kredit . "</td>";
    $rows .= "<td>" . $data->jenis . "</td>";
    $rows .= "<td>" . $akun . "</td>";
    $rows .= "<td width='75px' align='center'>" . $printKuitansi . "</td>";
    $rows .= "</tr>";
}

$pagination = '';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($page == $i) {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-primary mx-1 my-1 " data-page="' . $i . '">' . $i . '</a> ';
    } else {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-default mx-1 my-1 " data-page="' . $i . '">' . $i . '</a> ';
    };
}

echo json_encode(['rows' => $rows, 'pagination' => $pagination, 'totalRecords' => $totalRows]);
